<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\MaxLength;

/**
 * Class NotRequiredCompanyField
 * @package FCAPoland\FormsLib\Field
 */
class NotRequiredCompanyField extends CompanyField
{
    /**
     * Set default rules for this field
     */
    protected function setDefaultRules()
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }
        $this->setRules(
            [
                MaxLength::class => [200],
            ]
        );
    }
}
