<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\IsEmail;
use FCAPoland\FormsLib\Field\Rule\MaxLength;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;

/**
 * Class RepeatEmailField
 * @package FCAPoland\FormsLib\Field
 */
class RepeatEmailField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_EMAIL;

    /**
     * @var string
     */
    protected $name = 'repeat_email';

    /**
     * @var string
     */
    protected $place_holder = 'Powtórz e-mail';

    /**
     * Set default rules for this field
     */
    protected function setDefaultRules()
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                IsEmail::class => [],
                MaxLength::class => [100],
            ]
        );
    }

    /**
     * Check if value is valid
     * @param $value
     * @param $value_for_compare
     * @return bool
     */
    public function isValidRepeatEmail($value, $value_for_compare): bool
    {
        // Sprawdzenie czy wartość jest prawidłowa zgodnie z zasadami pola
        $this->isValid($value);
        // Sprawdzenie czy wartość jest taka sama jak wzorcowa
        if ($value != $value_for_compare) {
            $this->error_messages[] = "Adresy e-mail nie są takie same";
        }
        return count($this->error_messages) == 0;
    }
}
