<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\InArray;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;
use FCAPoland\LeadsAPIHelper\Lead;

/**
 * Class CommunicationChannelField
 * @package FCAPoland\FormsLib\Field
 */
class CommunicationChannelField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_SELECT;

    /**
     * @var string
     */
    protected $name = 'communication_channel';

    /**
     * @var string
     */
    protected $label = 'Preferowana forma kontaktu';

    public function __construct(array $options = null)
    {
        if ($options === null) {
            $this->setOptionValues([
                Lead::COMMUNICATION_CHANNEL_TELEPHONE => 'Telefon',
                Lead::COMMUNICATION_CHANNEL_MAIL => 'E-mail',
                Lead::COMMUNICATION_CHANNEL_VIDEO => 'Rozmowa wideo',
            ]);
        } else {
            $this->setOptionValues($options);
        }
        parent::__construct();
    }

    protected function setDefaultRules(): void
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                InArray::class => [array_keys($this->getOptionValues())]
            ]
        );
    }
}
