<?php


namespace Unit\Resource;


use PHPUnit\Framework\TestCase;

/**
 * Class DealerTest
 * @package Unit\Resource
 */
class DealerTest extends TestCase
{
    protected $fake_dealer_data =[
        "code"=> "1111111",
        "sitecode"=> "000",
        "brand"=> "00",
        "name"=> "TEST",
        "type"=> "sales",
        "subdealer"=> false,
        "main_dealer"=> "",
        "legal_entity"=> "1111111",
        "address"=> [
            "street"=> "Testowa",
            "post_code"=> "91-527",
            "city"=> "ŁÓDŹ",
            "region"=> [
                "id"=> 13,
                "code"=> "LDZ",
                "name"=> "łódzkie"
            ]
        ],
        "OIC"=> "00000000",
        "coordinates"=> [
            "longitude"=> "119.505603",
            "latitude"=> "151.81701"
        ],
        "website" => "http://test.pl",
        "email"=> "test@test.pl",
        "phones"=> [
            "666666666",
            "666666666"
        ],
        "fax"=> "666666666",
        "gdpr"=> [
            "dpo"=> null
        ]
    ];

    public function testStorageObject()
    {
        $object = new \FCAPoland\FormsLib\Resource\Dealer([]);
        $this->assertInstanceOf(\FCAPoland\FormsLib\Resource\Dealer::class, $object);
    }

    public function testBasic()
    {
        $object = new \FCAPoland\FormsLib\Resource\Dealer($this->fake_dealer_data);
        $this->assertEquals('1111111', $object->getSINCOM());
        $this->assertEquals('000', $object->getSiteCode());
        $this->assertEquals('00', $object->getBrandId());
        $this->assertEquals('TEST', $object->getName());
        $this->assertEquals('test@test.pl', $object->getEmail());
        $this->assertEquals('ŁÓDŹ', $object->getAddressCity());
        $this->assertEquals('666666666', $object->getPhone());
    }
}
