<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

/**
 * Interface FieldInterface
 * @package FCAPoland\FormsLib\Field
 */
interface FieldInterface
{
    public function getValue();
    public function getRules(): array;
    public function getRuleObjects(): array;
    public function getType(): string;
    public function getName(): string;
    public function getLabel(): ?string;
    public function getPlaceHolder(): ?string;
    public function isRequired(): bool;
    public function getFormat(): ?string;
    public function getOptionValues(): ?array;
    public function setValue($value): void;
    public function setRules(array $rules): void;
    public function setType(string $type): void;
    public function setName(string $name): void;
    public function setLabel(string $label): void;
    public function setPlaceHolder(string $place_holder): void;
    public function setRequired(bool $required): void;
    public function setFormat(string $format): void;
    public function setOptionValues(array $options): void;
    public function isValid($value): bool;
    public function initRules(): void;
    public function getFieldClassName(): string;
    public function getErrorsMessages(): array;
}
