<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\ClientParam;

/**
 * Interface ClientParamInterface
 * @package FCAPoland\FormsLib\ClientParam
 */
interface ClientParamInterface
{
    const PARAM_CID = 'cp_cid';
    const PARAM_OID = 'cp_oid';
    const PARAM_SOURCE = 'cp_source';
    const PARAM_CAMPAIGN_ID = 'cp_campaignid';
    const PARAM_OFFER_ID = 'cp_offerid';
    const PARAM_BANNER_ID = 'cp_bannerid';
    const PARAM_ADVERTISER_ID = 'cp_advertiserid';
    const PARAM_PUBLISHER = 'cp_publisher';

    public function getParam(string $key): ?string;
    public function getCID(): ?int;
    public function getOID(): ?int;
    public function getSource(): ?string;
    public function getCampaignID(): ?string;
    public function getOfferID(): ?string;
    public function getBannerID(): ?string;
    public function getAdvertiserID(): ?string;
    public function getPublisher(): ?string;
    public function setParam(string $kay, $value): ClientParamInterface;
    public function setCID(int $value): ClientParamInterface;
    public function setOID(int $value): ClientParamInterface;
    public function setSource(string $value): ClientParamInterface;
    public function setCampaignID(string $value): ClientParamInterface;
    public function setOfferID(string $value): ClientParamInterface;
    public function setBannerID(string $value): ClientParamInterface;
    public function setAdvertiserID(string $value): ClientParamInterface;
    public function setPublisher(string $value): ClientParamInterface;
    public function getAllParams(): array;
}
