<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\MaxLength;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;

/**
 * Class CompanyField
 * @package FCAPoland\FormsLib\Field
 */
class CompanyField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_TEXT;

    /**
     * @var string
     */
    protected $name = 'company';

    /** @var bool */
    protected $required = false;

    /**
     * @var string
     */
    protected $place_holder = 'Nazwa firmy';

    protected function setDefaultRules(): void
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                MaxLength::class => [200],
            ]
        );
    }
}
