<?php


namespace Unit;


use FCAPoland\FormsLib\Config\ConfigInterface;
use FCAPoland\FormsLib\Config\FCAAPIAuth;
use FCAPoland\FormsLib\Exception\InvalidArgumentException;
use PHPUnit\Framework\TestCase;

/**
 * Class FCAAPIAuthTest
 * @package Unit
 */
class FCAAPIAuthTest extends TestCase
{
    protected $correct_config = [
        'api_url' => 'https://xxx.xxx.pl/leads',
        'api_user' => 'xxx',
        'api_pass' => 'xxx'
    ];
    protected $incorrect_config = ['test' => 'test'];

    public function testCreateObject()
    {
        $object = new FCAAPIAuth();
        $this->assertInstanceOf(ConfigInterface::class, $object);
    }

    public function testEmpty()
    {
        $object = new FCAAPIAuth();
        $this->assertNull($object->getApiUrl());
        $this->assertNull($object->getApiUser());
        $this->assertNull($object->getApiPass());

    }

    public function testCorrectBasicSettings()
    {
        $object = new FCAAPIAuth();
        $this->assertEmpty($object->getConfig());
        $object->setConfig($this->correct_config);
        $this->assertEquals($this->correct_config, $object->getConfig());

        $this->assertEquals($this->correct_config['api_url'], $object->getApiUrl());
        $this->assertEquals($this->correct_config['api_user'], $object->getApiUser());
        $this->assertEquals($this->correct_config['api_pass'], $object->getApiPass());
    }

    public function testInCorrectBasicSettings()
    {
        $object = new FCAAPIAuth();
        $this->assertEmpty($object->getConfig());
        $this->expectException(InvalidArgumentException::class);
        $object->setConfig($this->incorrect_config);
        $this->assertEquals([], $object->getConfig());
    }

}