<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\ClientParam;

/**
 * Class BaseClientParam
 *
 * @package FCAPoland\FormsLib\ClientParam
 *
 */
class BaseClientParam implements ClientParamInterface
{
    /** @var array  */
    protected $storage = [];

    public function getParam(string $key): ?string
    {
        return $this->storage[$key] ?? null;
    }

    public function getCID(): ?int
    {
        return $this->storage[self::PARAM_CID] ?? null;
    }

    public function getOID(): ?int
    {
        return $this->storage[self::PARAM_OID] ?? null;
    }

    public function getSource(): ?string
    {
        return $this->storage[self::PARAM_SOURCE] ?? null;
    }

    public function getCampaignID(): ?string
    {
        return $this->storage[self::PARAM_CAMPAIGN_ID] ?? null;
    }

    public function getOfferID(): ?string
    {
        return $this->storage[self::PARAM_OFFER_ID] ?? null;
    }

    public function getBannerID(): ?string
    {
        return $this->storage[self::PARAM_BANNER_ID] ?? null;
    }

    public function getAdvertiserID(): ?string
    {
        return $this->storage[self::PARAM_ADVERTISER_ID] ?? null;
    }

    public function getPublisher(): ?string
    {
        return $this->storage[self::PARAM_PUBLISHER] ?? null;
    }

    public function setParam(string $kay, $value): ClientParamInterface
    {
        $this->storage[$kay] = $value;
        return $this;
    }

    public function setCID(int $value): ClientParamInterface
    {
        return $this->setParam(self::PARAM_CID, $value);
    }

    public function setOID(int $value): ClientParamInterface
    {
        return $this->setParam(self::PARAM_OID, $value);
    }

    public function setSource(string $value): ClientParamInterface
    {
        return $this->setParam(self::PARAM_SOURCE, $value);
    }

    public function setCampaignID(string $value): ClientParamInterface
    {
        return $this->setParam(self::PARAM_CAMPAIGN_ID, $value);
    }

    public function setOfferID(string $value): ClientParamInterface
    {
        return $this->setParam(self::PARAM_OFFER_ID, $value);
    }

    public function setBannerID(string $value): ClientParamInterface
    {
        return $this->setParam(self::PARAM_BANNER_ID, $value);
    }

    public function setAdvertiserID(string $value): ClientParamInterface
    {
        return $this->setParam(self::PARAM_ADVERTISER_ID, $value);
    }

    public function setPublisher(string $value): ClientParamInterface
    {
        return $this->setParam(self::PARAM_PUBLISHER, $value);
    }

    public function getAllParams(): array
    {
        return [
            'cid' => $this->getCID(),
            'oid' => $this->getOID(),
            'source' => $this->getSource(),
            'campaignid' => $this->getCampaignID(),
            'offerid' => $this->getOfferID(),
            'bannerid' => $this->getBannerID(),
            'advertiserid' => $this->getAdvertiserID(),
            'publisher' => $this->getPublisher(),
        ];
    }

    public function clear(): void
    {
        $this->storage = [];
    }
}
