<?php


namespace Unit;


use FCAPoland\FormsLib\Field\BrandIDField;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;
use FCAPoland\FormsLib\Message;
use PHPUnit\Framework\TestCase;

/**
 * Class MessageTest
 * @package Unit
 */
class MessageTest extends TestCase
{
    public function testCreateObject()
    {
        $object = Message::getInstance();
        $this->assertInstanceOf(Message::class, $object);
    }

    public function testBasic()
    {
        $message_string = 'Test1234';
        Message::getInstance()->setMessages([
            BrandIDField::class => [
                NotEmpty::class => $message_string
            ]
        ]);
        $field = new NotEmpty(new BrandIDField(BrandIDField::TYPE_SELECT, ['00' => 'Fiat']));
        $this->assertEquals($message_string,  Message::getInstance()->getMessageFor($field));
    }
}