<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\CsrfProtector;

/**
 * Class CsrfField
 * @package FCAPoland\FormsLib\Field
 */
class CsrfField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_HIDDEN;

    /**
     * @var string
     */
    protected $name = 'csrf_protect_field_d3d332d22ds32d2d2d092m_da';

    /**
     * RepeatEmailField constructor.
     * @param null $field_name
     */
    public function __construct($field_name = null)
    {
        if ($field_name !== null and is_string($field_name)) {
            $this->setName($field_name);
        }
        $this->setValue(CsrfProtector::getToken($this->getName()));
        parent::__construct();
    }

    protected function setDefaultRules(): void
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }
    }

    public function isValid($value): bool
    {
        if (!CsrfProtector::validate($value, $this->getName())) {
            $this->error_messages[] = "Wystąpił problem, proszę spróbować później.";
        }
        return count($this->error_messages) == 0;
    }

    public function regenerateCsrfValueToken(): string
    {
        $this->setValue(CsrfProtector::getToken($this->getName()));
        return $this->getValue();
    }
}
