<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field\Rule;

use FCAPoland\FormsLib\Field\FieldInterface;

/**
 * Interface RuleInterface
 * @package FCAPoland\FormsLib\Field\Rule
 */
interface RuleInterface
{
    public function isValidValue($value): bool;
    public function setRegex(?string $regex);
    public function getRegex(): ?string;
    public function getRuleName(): string;
    public function getFieldClassName(): ?string;
    public function getField(): ?FieldInterface;
    public function getMessage(): string;
}
