<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\InArray;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;
use FCAPoland\FormsLib\Field\Rule\ValidDealerSincom;

/**
 * Class DealerSincomField
 * @package FCAPoland\FormsLib\Field
 */
class DealerSincomField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_SELECT;

    /**
     * @var string
     */
    protected $name = 'dealer_sincom';

    /** @var bool */
    protected $required = true;

    /**
     * @var string
     */
    protected $place_holder = 'Wybierz dealera';

    /**
     * @param array|null $available_dealer_list
     */
    public function __construct(?array $available_dealer_list = [])
    {
        $this->setOptionValues($available_dealer_list);
        parent::__construct();
    }

    protected function setDefaultRules(): void
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        if ($this->getOptionValues() && count($this->getOptionValues()) > 1) {
            $this->setRules(
                [
                    NotEmpty::class => [],
                    ValidDealerSincom::class => [],
                    InArray::class => [array_keys($this->getOptionValues())]
                ]
            );
        } else {
            $this->setRules(
                [
                    NotEmpty::class => [],
                    ValidDealerSincom::class => [],
                ]
            );
        }
    }
}
