<?php


namespace Unit;

use FCAPoland\ApiPrivacyHelper\StorageInterface;
use FCAPoland\FormsLib\Storage;

/**
 * Class StorageTest
 * @package Unit
 */
class StorageTest extends \PHPUnit\Framework\TestCase
{

    public function testStorageObject()
    {
        $storage = new Storage(STORAGE_DIR);
        $this->assertInstanceOf(StorageInterface::class, $storage);
    }

    public function test1EmptyStorage()
    {
        $storage = new Storage(STORAGE_DIR);
        $this->assertNull($storage->getDealers('00'));
        $this->assertNull($storage->getPrivacyPolicy('xxx'));
        $this->assertNull($storage->getDisclaimer(666));
        $storage->removeStorage();
    }

    public function test2NotEmpty()
    {
        $value = 'value';
        $value2 = 'value2';
        $value3 = 'value3';
        $value4 = 'value4';
        $storage = new Storage(STORAGE_DIR);

        $this->assertNull($storage->getDealers('00'));
        $this->assertNull($storage->getPrivacyPolicy('xxx'));
        $this->assertNull($storage->getDisclaimer(666));
        $this->assertNull($storage->readFromStorage('test'));

        $storage->saveDealers('00', $value);
        $storage->savePrivacyPolicy('xxx', $value2);
        $storage->saveDisclaimer(666, $value3);
        $storage->saveToStorage('test', $value4);
        $this->assertNotNull($storage->getDealers('00'));
        $this->assertNotNull($storage->getPrivacyPolicy('xxx'));
        $this->assertNotNull($storage->getDisclaimer(666));
        $this->assertNotNull($storage->readFromStorage('test'));

        $this->assertEquals($value, $storage->getDealers('00'));
        $this->assertNotFalse($value2, $storage->getPrivacyPolicy('xxx'));
        $this->assertNotFalse($value3, $storage->getDisclaimer(666));
        $this->assertNotFalse($value4, $storage->readFromStorage('test'));
        $storage->removeStorage();
    }
}
