<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field\Rule;

use FCAPoland\FormsLib\Field\FieldInterface;
use FCAPoland\FormsLib\Message;

/**
 * Class BaseRule
 * @package FCAPoland\FormsLib\Field\Rule
 */
abstract class BaseRule implements RuleInterface
{
    /**
     * @var string|null
     */
    protected $regex;

    public function __construct(protected \FCAPoland\FormsLib\Field\FieldInterface $field)
    {
    }

    public function isValidValue($value): bool
    {
        // Zabezpieczenie na nieprzekazanie wartości z pola.
        // np. wymagane pole od marki (brand_id) nie jest przekazane, czyli w domyśle ma wartość null
        // Dodatkowo sprawdzane, jest czy wartość walidowana jest stringiem, dla preg_match to ważne.
        if ($this->field->isRequired() and ($value === null or !is_string($value) and !is_int($value))) {
            return false;
        }
        // preg_match przyjmuje jako 2 parametr stringi
        return (bool) preg_match($this->regex, (string) $value);
    }

    public function setRegex(?string $regex): void
    {
        $this->regex = $regex;
    }

    public function getRegex(): ?string
    {
        return $this->regex;
    }

    public function getRuleName(): string
    {
        return static::class;
    }

    public function getFieldClassName(): string
    {
        return $this->field->getFieldClassName();
    }

    public function getField(): ?FieldInterface
    {
        return $this->field;
    }

    public function getMessage(): string
    {
        return Message::getInstance()->getMessageFor($this);
    }
}
