<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field\Rule;

/**
 * Class IsPhone
 * @package FCAPoland\FormsLib\Field\Rule
 * Akceptowane formaty numeru telefonu
 * xxx-xxx-xxx
 * xxxxxxxxx
 * +48 xxx-xxx-xxx
 * +48xxxxxxxxx
 */
class IsPhone extends BaseRule
{
    /** @var string  */
    protected $regex = '/^(\+48\s[1-9]\d\d\-\d{3}-\d{3}|\+48[1-9]\d{8}|[1-9]\d\d\-\d{3}-\d{3}|[1-9]\d{8})$/';
}
