<?php


namespace Unit;


use FCAPoland\FormsLib\Field\BrandIDField;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;
use FCAPoland\FormsLib\Message;
use PHPUnit\Framework\TestCase;

/**
 * Class MessageTest
 * @package Unit
 */
class MessageTest extends TestCase
{
    public function testCreateObject(): void
    {
        $message = Message::getInstance();
        $this->assertInstanceOf(Message::class, $message);
    }

    public function testBasic(): void
    {
        $message_string = 'Test1234';
        Message::getInstance()->setMessages([
            BrandIDField::class => [
                NotEmpty::class => $message_string
            ]
        ]);
        $notEmpty = new NotEmpty(new BrandIDField(BrandIDField::TYPE_SELECT, ['00' => 'Fiat']));
        $this->assertEquals($message_string,  Message::getInstance()->getMessageFor($notEmpty));
    }
}