#!/bin/bash
pushd `dirname $0` > /dev/null
if [ "$1" = "--help" ]; then
    echo "Usage: $0 [TEST_ARGUMENTS]"
    echo ""
    echo "One can pass additional arguments to the testing framework using TEST_ARGUMENTS, for example:"
    echo ""
    echo "  $0 --group failing"
    echo "  $0 --testsuite FunctionalTests"
    echo ""
    popd > /dev/null
    exit
fi
PHPUNIT_BIN="../vendor/bin/phpunit"
PHPUNIT_XML="../phpunit.xml"
if [ ! -e "$PHPUNIT_BIN" ]; then
    echo "ERROR: Could not find PHPUnit executable at $PHPUNIT_BIN"
    popd > /dev/null
    exit
fi
if [ ! -e "$PHPUNIT_XML" ]; then
    echo "ERROR: Could not find PHPUnit configuration at $PHPUNIT_XML"
    popd > /dev/null
    exit
fi
echo "Running PHPUnit tests..."
echo ""

./php.sh ./vendor/bin/phpunit -c phpunit.xml "${@:2}"

echo ""
echo "PHPUnit tests done."
popd > /dev/null
