<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\ClientParam;

/**
 * Class SessionClientParam
 * @package FCAPoland\FormsLib\ClientParam
 */
class SessionClientParam extends BaseClientParam
{
    public function __construct()
    {
        if (session_status() != PHP_SESSION_ACTIVE) {
            session_start();
        }
        if (isset($_SESSION[self::PARAM_CID]) and is_numeric($_SESSION[self::PARAM_CID])) {
            $this->setCID((int) $_SESSION[self::PARAM_CID]);
        }
        if (isset($_SESSION[self::PARAM_OID]) and is_numeric($_SESSION[self::PARAM_OID])) {
            $this->setOID((int) $_SESSION[self::PARAM_OID]);
        }
        if (isset($_SESSION[self::PARAM_SOURCE])) {
            $this->setSource((string) $_SESSION[self::PARAM_SOURCE]);
        }
        if (isset($_SESSION[self::PARAM_CAMPAIGN_ID])) {
            $this->setCampaignID((string) $_SESSION[self::PARAM_CAMPAIGN_ID]);
        }
        if (isset($_SESSION[self::PARAM_OFFER_ID])) {
            $this->setOfferID((string) $_SESSION[self::PARAM_OFFER_ID]);
        }
        if (isset($_SESSION[self::PARAM_BANNER_ID])) {
            $this->setBannerID((string) $_SESSION[self::PARAM_BANNER_ID]);
        }
        if (isset($_SESSION[self::PARAM_ADVERTISER_ID])) {
            $this->setAdvertiserID((string) $_SESSION[self::PARAM_ADVERTISER_ID]);
        }
        if (isset($_SESSION[self::PARAM_PUBLISHER])) {
            $this->setPublisher((string) $_SESSION[self::PARAM_PUBLISHER]);
        }
    }

    public function setCID(int $value): ClientParamInterface
    {
        if ($value !== 0 and $value != $this->getCID()) {
            $_SESSION[self::PARAM_CID] = $value;
            return parent::setCID($value);
        }
        return $this;
    }

    public function setOID(int $value): ClientParamInterface
    {
        if ($value !== 0 and $value != $this->getOID()) {
            $_SESSION[self::PARAM_OID] = $value;
            return parent::setOID($value);
        }
        return $this;
    }

    public function setSource(string $value): ClientParamInterface
    {
        if ($value !== '' && $value !== '0' and $value != $this->getSource()) {
            $_SESSION[self::PARAM_SOURCE] = $value;
            return parent::setSource($value);
        }
        return $this;
    }

    public function setCampaignID(string $value): ClientParamInterface
    {
        if ($value !== '' && $value !== '0' and $value != $this->getCampaignID()) {
            $_SESSION[self::PARAM_CAMPAIGN_ID] = $value;
            return parent::setCampaignID($value);
        }
        return $this;
    }

    public function setOfferID(string $value): ClientParamInterface
    {
        if ($value !== '' && $value !== '0' and $value != $this->getOfferID()) {
            $_SESSION[self::PARAM_OFFER_ID] = $value;
            return parent::setOfferID($value);
        }
        return $this;
    }

    public function setBannerID(string $value): ClientParamInterface
    {
        if ($value !== '' && $value !== '0' and $value != $this->getBannerID()) {
            $_SESSION[self::PARAM_BANNER_ID] = $value;
            return parent::setBannerID($value);
        }
        return $this;
    }

    public function setAdvertiserID(string $value): ClientParamInterface
    {
        if ($value !== '' && $value !== '0' and $value != $this->getAdvertiserID()) {
            $_SESSION[self::PARAM_ADVERTISER_ID] = $value;
            return parent::setAdvertiserID($value);
        }
        return $this;
    }

    public function setPublisher(string $value): ClientParamInterface
    {
        if ($value !== '' && $value !== '0' and $value != $this->getPublisher()) {
            $_SESSION[self::PARAM_PUBLISHER] = $value;
            return parent::setPublisher($value);
        }
        return $this;
    }
}
