<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\InArray;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;
use FCAPoland\LeadsAPIHelper\Exception\LeadsAPIHelperException;

/**
 * Class ModelIDField
 * @package FCAPoland\FormsLib\Field
 */
class ModelIDField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_SELECT;

    /**
     * @var string
     */
    protected $name = 'model_id';

    /**
     * @var string
     */
    protected $label = 'Wybierz model';


    public function __construct(string $type, array $options = null)
    {
        if ($options !== null) {
            $this->setOptionValues($options);
        }
        if (!in_array($type, BaseField::getFieldTypes())) {
            throw new LeadsAPIHelperException('Incorrect field type, check form configuration for ModelID field');
        }
        $this->setType($type);
        parent::__construct();
    }

    protected function setDefaultRules(): void
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        if ($this->option_values === null) {
            $rules =  [
                NotEmpty::class => [],
            ];
        } else {
            $rules =  [
                NotEmpty::class => [],
                InArray::class => [array_keys($this->getOptionValues())]
            ];
        }
        $this->setRules($rules);
    }
}
