<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\CheckRecaptcha;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;

/**
 * Class RecaptchaField
 * @package FCAPoland\FormsLib\Field
 */
class RecaptchaField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_RECAPTCHA;

    /**
     * @var string
     */
    protected $name = 'g-recaptcha-response';

    /** @var bool */
    protected $required = true;

    public function __construct(private readonly string $site_key, private readonly string $secret_key)
    {
        parent::__construct();
    }

    protected function setDefaultRules(): void
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                CheckRecaptcha::class => [$this->site_key, $this->secret_key]
            ]
        );
    }

    public function getSiteKey(): string
    {
        return $this->site_key;
    }
}
