<?php


namespace Unit;


use FCAPoland\FormsLib\Config\ConfigInterface;
use FCAPoland\FormsLib\Config\LibConfig;
use FCAPoland\FormsLib\Field\CTAField;
use FCAPoland\LeadsAPIHelper\Lead;
use PHPUnit\Framework\TestCase;

/**
 * Class LibConfigTest
 * @package Unit
 */
class LibConfigTest extends TestCase
{
    protected $correct_config = [
        'lead_api_cache' => './xxx',
        'policy_hash' => 'sss',
        'forms' => [
            'offerFormTestDrive' => [
                'id' => 'offerFormTestDrive',
                'enabled' => true,
                'with_subdealers' => true,
                'disclaimer_id' => 723,
                'brand_id'  =>  '77',
                'cid'    =>  '7777',
                'oid'    =>  '7777',
                'source' =>  'dem',
                'fields' => [
                    CTAField::class => [Lead::TYPE_TESTDRIVE]
                ],
            ],
        ]
    ];

    public function testCreateObject(): void
    {
        $libConfig = new LibConfig();
        $this->assertInstanceOf(ConfigInterface::class, $libConfig);
    }

    public function testEmpty(): void
    {
        $libConfig = new LibConfig();
        $this->assertNotNull($libConfig->getStoragePath());
        $this->assertNull($libConfig->getPrivacyPolicyHash());
        $this->assertNull($libConfig->getForms());
    }

    public function testCorrectConfig(): void
    {
        $libConfig = new LibConfig();
        $libConfig->setConfig($this->correct_config);

        $this->assertEquals('./xxx' , $libConfig->getStoragePath());
        $this->assertEquals('sss', $libConfig->getPrivacyPolicyHash());

        $this->assertIsArray($libConfig->getForms());
        $this->assertIsArray($libConfig->getConfig());
    }
}