<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Config;

use FCAPoland\FormsLib\Exception\InvalidArgumentException;
use TypeError;

/**
 * Class FcaApiAuth
 * @package FCAPoland\FormsLib\Config
 */
class FCAAPIAuth extends BaseConfig
{
    public function setConfig(array $config): void
    {
        if (!isset($config['api_url']) or !isset($config['api_user']) or !isset($config['api_pass'])) {
            throw new InvalidArgumentException('FCA LEAD API - AUTH CONFIG INCORRECT');
        }
        try {
            $this->setApiUrl($config['api_url']);
            $this->setApiUser($config['api_user']);
            $this->setApiPass($config['api_pass']);
        } catch (TypeError) {
            throw new InvalidArgumentException('FCA LEAD API - AUTH CONFIG INCORRECT (not string values)');
        }
    }

    public function getApiUrl(): ?String
    {
        return $this->config['api_url'] ?? null;
    }

    private function setApiUrl(String $api_url): void
    {
        $this->config['api_url'] = $api_url;
    }

    public function getApiUser(): ?String
    {
        return $this->config['api_user'] ?? null;
    }

    private function setApiUser(String $api_user): void
    {
        $this->config['api_user'] = $api_user;
    }

    public function getApiPass(): ?String
    {
        return $this->config['api_pass'] ?? null;
    }

    private function setApiPass(String $api_pass): void
    {
        $this->config['api_pass'] = $api_pass;
    }
}
