<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\InArray;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;
use FCAPoland\LeadsAPIHelper\Exception\LeadsAPIHelperException;

/**
 * Class EnergyTypeField
 * @package FCAPoland\FormsLib\Field
 */
class EnergyTypeField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_SELECT;

    /**
     * @var string
     */
    protected $name = 'energy_type';

    /**
     * @var string
     */
    protected $label = 'Wybierz typ napędu';

    public function __construct($type, $options = null)
    {
        $this->setOptionValues($options);
        if (!in_array($type, BaseField::getFieldTypes())) {
            throw new LeadsAPIHelperException(
                'Incorrect energy type, check form configuration for energy type field'
            );
        }
        $this->setType($type);
        parent::__construct();
    }

    protected function setDefaultRules(): void
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                InArray::class => [array_keys($this->getOptionValues())]
            ]
        );
    }
}
