<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field\Rule;

use FCAPoland\FormsLib\Field\FieldInterface;
use ReCaptcha\ReCaptcha;

/**
 * Class CheckRecaptcha
 * @package FCAPoland\FormsLib\Field\Rule
 */
class CheckRecaptcha extends BaseRule
{

    public function __construct(FieldInterface $field, private readonly string $site_key, private readonly string $secret_key)
    {
        parent::__construct($field);
    }

    public function isValidValue($value): bool
    {
        // Zabezpieczenie na nieprzekazanie wartości z pola.
        // np wymagane pole od marki (brand_id) nie jest przekazane, czyli w domyśle ma wartość null
        if ($value === null) {
            return false;
        }
        $recaptcha = new ReCaptcha($this->secret_key);
        $response = $recaptcha->verify($value);
        return $response->isSuccess();
    }

    public function getSiteKey(): string
    {
        return $this->site_key;
    }

    public function getSecretKey(): string
    {
        return $this->secret_key;
    }
}
