<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field\Rule;

use FCAPoland\FormsLib\Field\FieldInterface;

/**
 * Class MaxLength
 * @package FCAPoland\FormsLib\Field\Rule
 */
class MaxLength extends BaseRule
{
    public function __construct(FieldInterface $field, $max_length)
    {
        parent::__construct($field);
        // Auto gen regex for $max_length
        $this->regex = sprintf('/^.{0,%s}$/', $max_length);
    }
}
