<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\MaxLength;

/**
 * Class VinField
 * @package FCAPoland\FormsLib\Field
 */
class VinField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_HIDDEN;

    /**
     * @var string
     */
    protected $name = 'vin';

    /** @var bool */
    protected $required = false;

    /**
     * @var string
     */
    protected $place_holder = 'Vin';

    protected function setDefaultRules(): void
    {
        $this->setRules(
            [
                MaxLength::class => [17],
            ]
        );
    }
}
