<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\NotEmpty;
use FCAPoland\FormsLib\Field\Rule\ValidPostCode;

/**
 * Class ZipCodeField
 * @package FCAPoland\FormsLib\Field
 */
class ZipCodeField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_TEXT;

    /**
     * @var string
     */
    protected $name = 'zipcode';

    /** @var bool */
    protected $required = true;

    /**
     * @var string
     */
    protected $format = '99-999';

    /**
     * @var string
     */
    protected $place_holder = 'Kod pocztowy';

    protected function setDefaultRules(): void
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                ValidPostCode::class => [],
            ]
        );
    }
}
