<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Form;

use FCAPoland\FormsLib\Field\FieldInterface;

/**
 * Class FormData
 * @package FCAPoland\FormsLib\Form
 */
class FormData
{
    /**
     * @param array $properties List of object's properties that can be directly returned when invoking `asArray()` method
     */
    public function __construct(protected array $properties = [])
    {
        return $this;
    }

    public function setProperties($form_data): FormData
    {
        $this->properties = $form_data;
        return $this;
    }

    private function getProperty(string $name)
    {
        return $this->properties[$name] ?? null;
    }

    public function getPropertyByField(FieldInterface $field)
    {
        return $this->properties[$field->getName()] ?? null;
    }

    public function getProperties(): array
    {
        return $this->properties;
    }

    public function hasProperty($name): bool
    {
        return array_key_exists($name, $this->properties);
    }

    public function getCTA()
    {
        return $this->getProperty('cta');
    }

    public function getBrandID()
    {
        return $this->getProperty('brand_id');
    }

    public function getModelID()
    {
        return $this->getProperty('model_id');
    }

    public function getFirstName()
    {
        return $this->getProperty('firstname');
    }

    public function getLastName()
    {
        return $this->getProperty('lastname');
    }

    public function getEmail()
    {
        return $this->getProperty('email');
    }

    public function getAddress()
    {
        return $this->getProperty('address');
    }

    public function getCity()
    {
        return $this->getProperty('city');
    }

    public function getZipCode()
    {
        return $this->getProperty('zipcode');
    }

    public function getCompany()
    {
        return $this->getProperty('company');
    }

    public function getPhone()
    {
        return $this->getProperty('phone');
    }

    public function getDealerSincom()
    {
        return $this->getProperty('dealer_sincom');
    }

    public function getAppointmentDate()
    {
        return $this->getProperty('appointment_date');
    }

    public function getRelatedID()
    {
        return $this->getProperty('related_id');
    }

    public function getOrigin()
    {
        return $this->getProperty('origin');
    }

    public function getUserAgent()
    {
        return $this->getProperty('user_agent');
    }

    public function getDevice()
    {
        return $this->getProperty('device');
    }

    public function getIP()
    {
        return $this->getProperty('ip');
    }

    public function getComment()
    {
        return $this->getProperty('comment');
    }

    public function getVin()
    {
        return $this->getProperty('vin');
    }

    public function getEnergyType()
    {
        return $this->getProperty('energy_type');
    }

    public function getCommunicationChannel()
    {
        return $this->getProperty('communication_channel');
    }

    public function getAgreementByKey(string $key)
    {
        return $this->getProperty($key);
    }
}
