<?php


namespace Unit;


use FCAPoland\FormsLib\ClientParam\BaseClientParam;
use FCAPoland\FormsLib\ClientParam\ClientParamInterface;
use PHPUnit\Framework\TestCase;

/**
 * Class ClientParamTest
 * @package Unit
 */
class ClientParamTest extends TestCase
{
    public function testStorageObject(): void
    {
        $baseClientParam = new BaseClientParam();
        $this->assertInstanceOf(ClientParamInterface::class, $baseClientParam);
    }

    public function testEmptyObject(): void
    {
        $baseClientParam = new BaseClientParam();
        $this->assertNull($baseClientParam->getCID());
        $this->assertNull($baseClientParam->getOID());
        $this->assertNull($baseClientParam->getSource());
        $this->assertNull($baseClientParam->getOfferID());
        $this->assertNull($baseClientParam->getCampaignID());
        $this->assertNull($baseClientParam->getBannerID());
        $this->assertNull($baseClientParam->getPublisher());
        $this->assertNull($baseClientParam->getAdvertiserID());
        $this->assertNull($baseClientParam->getParam('test'));
        $this->assertIsArray($baseClientParam->getAllParams());
    }

    public function testSetters(): void
    {
        $baseClientParam = new BaseClientParam();
        $this->assertNull($baseClientParam->getCID());
        $this->assertNull($baseClientParam->getOID());
        $this->assertNull($baseClientParam->getSource());
        $this->assertNull($baseClientParam->getOfferID());
        $this->assertNull($baseClientParam->getCampaignID());
        $this->assertNull($baseClientParam->getBannerID());
        $this->assertNull($baseClientParam->getPublisher());
        $this->assertNull($baseClientParam->getAdvertiserID());
        $this->assertNull($baseClientParam->getParam('test'));
        $this->assertIsArray($baseClientParam->getAllParams());

        $baseClientParam->setCID(11);
        $baseClientParam->setOID(22);
        $baseClientParam->setSource('source_test');
        $baseClientParam->setOfferID('offer_test');
        $baseClientParam->setCampaignID('campaign_test');
        $baseClientParam->setBannerID('banner_test');
        $baseClientParam->setPublisher('publisher_test');
        $baseClientParam->setAdvertiserID('advert_test');
        $baseClientParam->setParam('test', 'value_test');

        $this->assertEquals(11, $baseClientParam->getCID());
        $this->assertEquals(22, $baseClientParam->getOID());
        $this->assertEquals('source_test', $baseClientParam->getSource());
        $this->assertEquals('offer_test', $baseClientParam->getOfferID());
        $this->assertEquals('campaign_test', $baseClientParam->getCampaignID());
        $this->assertEquals('banner_test', $baseClientParam->getBannerID());
        $this->assertEquals('publisher_test', $baseClientParam->getPublisher());
        $this->assertEquals('advert_test', $baseClientParam->getAdvertiserID());
        $this->assertEquals('value_test', $baseClientParam->getParam('test'));

    }

    public function testClear(): void
    {
        $baseClientParam = new BaseClientParam();
        $this->assertNull($baseClientParam->getCID());
        $baseClientParam->setCID(111);
        $this->assertNotNull($baseClientParam->getCID());
        $baseClientParam->clear();
        $this->assertNull($baseClientParam->getCID());
    }
}
