<?php


namespace Unit;


use FCAPoland\FormsLib\Config\ConfigInterface;
use FCAPoland\FormsLib\Config\FCAAPIAuth;
use FCAPoland\FormsLib\Exception\InvalidArgumentException;
use PHPUnit\Framework\TestCase;

/**
 * Class FCAAPIAuthTest
 * @package Unit
 */
class FCAAPIAuthTest extends TestCase
{
    protected $correct_config = [
        'api_url' => 'https://xxx.xxx.pl/leads',
        'api_user' => 'xxx',
        'api_pass' => 'xxx'
    ];
    protected $incorrect_config = ['test' => 'test'];

    public function testCreateObject(): void
    {
        $fcaapiAuth = new FCAAPIAuth();
        $this->assertInstanceOf(ConfigInterface::class, $fcaapiAuth);
    }

    public function testEmpty(): void
    {
        $fcaapiAuth = new FCAAPIAuth();
        $this->assertNull($fcaapiAuth->getApiUrl());
        $this->assertNull($fcaapiAuth->getApiUser());
        $this->assertNull($fcaapiAuth->getApiPass());

    }

    public function testCorrectBasicSettings(): void
    {
        $fcaapiAuth = new FCAAPIAuth();
        $this->assertEmpty($fcaapiAuth->getConfig());
        $fcaapiAuth->setConfig($this->correct_config);
        $this->assertEquals($this->correct_config, $fcaapiAuth->getConfig());

        $this->assertEquals($this->correct_config['api_url'], $fcaapiAuth->getApiUrl());
        $this->assertEquals($this->correct_config['api_user'], $fcaapiAuth->getApiUser());
        $this->assertEquals($this->correct_config['api_pass'], $fcaapiAuth->getApiPass());
    }

    public function testInCorrectBasicSettings(): void
    {
        $fcaapiAuth = new FCAAPIAuth();
        $this->assertEmpty($fcaapiAuth->getConfig());
        $this->expectException(InvalidArgumentException::class);
        $fcaapiAuth->setConfig($this->incorrect_config);
        $this->assertEquals([], $fcaapiAuth->getConfig());
    }

}