<?php


namespace Unit;


use FCAPoland\FormsLib\Field\FirstNameField;
use FCAPoland\FormsLib\Form\FormData;
use FCAPoland\LeadsAPIHelper\Lead;
use PHPUnit\Framework\TestCase;

/**
 * Class FormDataTest
 * @package Unit
 */
class FormDataTest extends TestCase
{
    public function testEmptyFormData(): void
    {
        $formData = new FormData([]);
        $this->assertNull($formData->getPropertyByField(new FirstNameField()));
        $this->assertFalse($formData->hasProperty('1'));
        $this->assertNull($formData->getCTA());
        $this->assertNull($formData->getBrandID());
        $this->assertNull($formData->getModelID());
        $this->assertNull($formData->getFirstName());
        $this->assertNull($formData->getLastName());
        $this->assertNull($formData->getEmail());
        $this->assertNull($formData->getAddress());
        $this->assertNull($formData->getCity());
        $this->assertNull($formData->getZipCode());
        $this->assertNull($formData->getCompany());
        $this->assertNull($formData->getPhone());
        $this->assertNull($formData->getDealerSincom());
        $this->assertNull($formData->getAppointmentDate());
        $this->assertNull($formData->getRelatedID());
        $this->assertNull($formData->getOrigin());
        $this->assertNull($formData->getUserAgent());
        $this->assertNull($formData->getDevice());
        $this->assertNull($formData->getIP());
        $this->assertNull($formData->getComment());
        $this->assertNull($formData->getCommunicationChannel());
        $this->assertNull($formData->getAgreementByKey('a'));
    }

    public function testFilledFormData(): void
    {
        $formData = new FormData([
            'cta'=>'TD',
            'brand_id' => '77',
            'model_id' => '150',
            'firstname' => 'Imie',
            'lastname' => 'Nazwisko',
            'email' => 'support@unicorn.net.pl',
            'address' => 'XXX',
            'city' => 'Prg',
            'zipcode' => '83-000',
            'company' => 'Firma',
            'phone' => '+48 000-000-000',
            'dealer_sincom' => '1111111.000',
            'appointment_date' => '20-02-2020',
            'related_id' => 1,
            'origin' => '...',
            'user_agent' => 'UserAgent',
            'device' => 'Mobile',
            'ip' => '0.0.0.0',
            'comment' => 'Com test',
            'communication_channel' => Lead::COMMUNICATION_CHANNEL_TELEPHONE,
            'agg_test' => 'test',
        ]);
        $this->assertFalse($formData->hasProperty('agg_test2'));
        $this->assertTrue($formData->hasProperty('agg_test'));
        $this->assertNotNull($formData->getCTA());
        $this->assertNotNull($formData->getBrandID());
        $this->assertNotNull($formData->getModelID());
        $this->assertNotNull($formData->getFirstName());
        $this->assertNotNull($formData->getLastName());
        $this->assertNotNull($formData->getEmail());
        $this->assertNotNull($formData->getAddress());
        $this->assertNotNull($formData->getCity());
        $this->assertNotNull($formData->getZipCode());
        $this->assertNotNull($formData->getCompany());
        $this->assertNotNull($formData->getPhone());
        $this->assertNotNull($formData->getDealerSincom());
        $this->assertNotNull($formData->getAppointmentDate());
        $this->assertNotNull($formData->getRelatedID());
        $this->assertNotNull($formData->getOrigin());
        $this->assertNotNull($formData->getUserAgent());
        $this->assertNotNull($formData->getDevice());
        $this->assertNotNull($formData->getIP());
        $this->assertNotNull($formData->getComment());
        $this->assertNotNull($formData->getCommunicationChannel());
        $this->assertNotNull($formData->getAgreementByKey('agg_test'));

        $this->assertEquals('TD', $formData->getCTA());
        $this->assertEquals('77', $formData->getBrandID());
        $this->assertEquals('150', $formData->getModelID());
        $this->assertEquals('Imie', $formData->getFirstName());
        $this->assertEquals('Nazwisko', $formData->getLastName());
        $this->assertEquals('support@unicorn.net.pl', $formData->getEmail());
        $this->assertEquals('XXX', $formData->getAddress());
        $this->assertEquals('Prg', $formData->getCity());
        $this->assertEquals('83-000', $formData->getZipCode());
        $this->assertEquals('Firma', $formData->getCompany());
        $this->assertEquals('+48 000-000-000', $formData->getPhone());
        $this->assertEquals('1111111.000', $formData->getDealerSincom());
        $this->assertEquals('20-02-2020', $formData->getAppointmentDate());
        $this->assertEquals(1, $formData->getRelatedID());
        $this->assertEquals('...', $formData->getOrigin());
        $this->assertEquals('UserAgent', $formData->getUserAgent());
        $this->assertEquals('Mobile', $formData->getDevice());
        $this->assertEquals('0.0.0.0', $formData->getIP());
        $this->assertEquals('Com test', $formData->getComment());
        $this->assertEquals(Lead::COMMUNICATION_CHANNEL_TELEPHONE, $formData->getCommunicationChannel());
        $this->assertEquals('test', $formData->getAgreementByKey('agg_test'));
    }
}
