<?php

namespace FCAPoland\LeadsAPIHelper;

class Lead
{
    private $properties = [
        'first_name' => null,
        'last_name' => null,
        'type' => null,
        'brand_id' => null,
        'email' => null,
        'phone_number' => null,
        'dealer_sincom' => null,
        'model_id' => null,
        'origin' => null,
    ];

    /**
     * @var int
     */
    private $id;

    public function __construct(array $properties = null)
    {
        if ($properties) {
            foreach ($properties as $property_name => $property_value) {
                $this->set($property_name, $property_value);
            }
        }
    }

    /**
     * @param $property
     * @param $value
     *
     * @throws InvalidArgumentException
     */
    public function set($property, $value)
    {
        if (!is_string($property)) {
            throw new InvalidArgumentException('Property name must be a string, ' . gettype($property) . ' given');
        }
        if (!array_key_exists($property, $this->properties)) {
            throw new InvalidArgumentException('Invalid property ' . $property);
        }
        if (!is_scalar($value)) {
            throw new InvalidArgumentException('Property value must be of scalar type, ' . gettype($value) . ' given');
        }
        $this->properties[$property] = $value;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return array
     */
    public function getProperties()
    {
        return $this->properties;
    }
}
