<?php

namespace Tests\Functional;

use FCAPoland\LeadsAPIHelper;

/**
 * Class DealersTest
 *
 * These tests require fully functional HTTP server serving API data from any source:
 *  - development
 *  - tests
 *  - production
 *
 * Please check `LEADS_API_URL` constant than can be set in PHPUnit's `bootstrap.php` file.
 *
 * @package Tests\Functional
 */
class CreateLeadTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var string
     */
    private $url;

    /**
     * @var string
     */
    private $username;

    /**
     * @var string
     */
    private $password;

    protected function setUp()
    {
        parent::setUp();

        if (defined('LEADS_API_URL')) {
            $this->url = LEADS_API_URL;
        }

        if (defined('LEADS_API_USERNAME')) {
            $this->username = LEADS_API_USERNAME;
        }

        if (defined('LEADS_API_PASSWORD')) {
            $this->password = LEADS_API_PASSWORD;
        }
    }

    public function testCreate()
    {
        $lead = new LeadsAPIHelper\Lead();

        $lead->set('first_name', 'Foo');
        $lead->set('last_name', 'Bar');
        $lead->set('type', 'RP');
        $lead->set('brand_id', '57');
        $lead->set('email', 'foo.bar@foobar.com.cx');
        $lead->set('phone_number', '612345679');
        $lead->set('dealer_sincom', '0720006.000');
        $lead->set('model_id', '604');
        $lead->set('origin', 'PhpUnit');

        $api_request = new LeadsAPIHelper\Request\Create($this->url, $this->username, $this->password);

        // Attach lead to the request
        $api_request->setLead($lead);

        $result = $api_request->execute();

        $this->assertTrue($result);
        $this->assertInternalType('int', $lead->getId());
        $this->assertEmpty($api_request->getError());
    }

    public function testCreateMissingType()
    {
        $lead = new LeadsAPIHelper\Lead();

        $lead->set('first_name', 'Foo');
        $lead->set('last_name', 'Bar');
        $lead->set('brand_id', '57');
        $lead->set('email', 'foo.bar@foobar.com.cx');
        $lead->set('phone_number', '612345679');
        $lead->set('dealer_sincom', '0720006.000');
        $lead->set('model_id', '604');
        $lead->set('origin', 'PhpUnit');

        $api_request = new LeadsAPIHelper\Request\Create($this->url, $this->username, $this->password);

        // Attach lead to the request
        $api_request->setLead($lead);

        $result = $api_request->execute();

        $this->assertFalse($result);
        $this->assertNull($lead->getId());
        $this->assertNotEmpty($api_request->getError());
        $this->assertEquals('Lead type is required', $api_request->getError());
    }
}
