<?php

namespace Tests\Unit;

use FCAPoland\LeadsAPIHelper\InvalidArgumentException;
use FCAPoland\LeadsAPIHelper\Lead;
use FCAPoland\LeadsAPIHelper\Request;
use PHPUnit\Framework\TestCase;

class LeadTest extends TestCase
{
    private $lead_properties_template = [
        'first_name'    => null,
        'last_name'     => null,
        'type'          => null,
        'brand_id'      => null,
        'email'         => null,
        'phone_number'  => null,
        'dealer_sincom' => null,
        'model_id'      => null,
        'origin'        => null,
    ];

    public function testPropertiesSetting()
    {
        $lead = new Lead();
        $this->assertAttributeEquals($this->lead_properties_template, 'properties', $lead);
        $lead->set('first_name', 'foo');
        $this->assertAttributeEquals(
            array_replace($this->lead_properties_template, ['first_name' => 'foo']),
            'properties',
            $lead
        );
        $this->assertEquals(
            array_replace($this->lead_properties_template, ['first_name' => 'foo']),
            $lead->getProperties()
        );
    }

    public function testInvalidPropertiesSetting()
    {
        $lead = new Lead();
        $this->expectException(InvalidArgumentException::class);
        $lead->set('invalid_property', 'foo');
    }

    public function testInvalidPropertyTypeSetting()
    {
        $lead = new Lead();
        $this->expectException(InvalidArgumentException::class);
        $lead->set('first_name', ['foo', 'bar']);
    }

    public function testIdSetGet()
    {
        $lead = new Lead();
        $lead->setId(123);
        $this->assertAttributeEquals(123, 'id', $lead);
        $this->assertEquals(123, $lead->getId());
    }
}
