<?php

namespace FCAPoland\LeadsAPIHelper;

/**
 * Class Masterkey
 * @package FCAPoland\LeadsAPIHelper
 */
class Masterkey
{
    /** @var int */
    private $id;

    /** @var string */
    private $brand;

    /** @var string */
    private $type;

    /** @var int */
    private $cid;

    /** @var int */
    private $oid;

    /** @var string */
    private $source;

    /**
     * Masterkey constructor.
     * @param int $id
     * @param string $brand
     * @param string $type
     * @param int $cid
     * @param int $oid
     * @param string $source
     */
    public function __construct($id, $brand, $type, $cid, $oid, $source)
    {
        $this->id = (int) $id;
        $this->brand = $brand;
        $this->type = $type;
        $this->cid = $cid;
        $this->oid = $oid;
        $this->source = $source;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return (int) $this->id;
    }

    /**
     * @return string
     */
    public function getBrand()
    {
        return (string) $this->brand;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @return int
     */
    public function getCid()
    {
        return $this->cid;
    }

    /**
     * @return int
     */
    public function getOid()
    {
        return $this->oid;
    }

    /**
     * @return string
     */
    public function getSource()
    {
        return $this->source;
    }
}
