<?php

namespace Tests\Unit;

use FCAPoland\LeadsAPIHelper\InvalidArgumentException;
use FCAPoland\LeadsAPIHelper\Lead;
use FCAPoland\LeadsAPIHelper\Request;
use PHPUnit\Framework\TestCase;

class LeadTest extends TestCase
{
    private $lead_properties_template = [
        'type'          => null,
        'brand_id'      => null,
        'masterkey_id'  => null,
        'first_name'    => null,
        'last_name'     => null,
        'company'       => null,
        'address'       => null,
        'zip_code'      => null,
        'city'          => null,
        'email'         => null,
        'privacy'       => [
            'Email' => null,
            'SMS' => null,
            'Phone' => null,
            'PLThirdParty' => null,
        ],
        'phone_number'  => null,
        'dealer_sincom' => null,
        'model_id'      => null,
        'related_id'    => null,
        'origin'        => null,
        'user_agent'    => null,
        'device'        => null,
        'ip'            => null,
    ];

    public function testPropertiesSetting()
    {
        $lead = new Lead();
        $this->assertAttributeEquals(null, 'first_name', $lead);
        $lead->setFirstName('foo');
        $this->assertAttributeEquals('foo','first_name', $lead);
        $this->assertEquals('foo', $lead->getFirstName());
        $this->assertEquals(
            array_replace($this->lead_properties_template, ['first_name' => 'foo']),
            $lead->getProperties()
        );
    }

    public function testInvalidPropertyTypeSetting()
    {
        $lead = new Lead();
        $this->expectException(InvalidArgumentException::class);
        $lead->setFirstName(['foo', 'bar']);
    }

    public function testIdSetGet()
    {
        $lead = new Lead();
        $lead->setId(123);
        $this->assertAttributeEquals(123, 'id', $lead);
        $this->assertEquals(123, $lead->getId());
    }

    // TODO: Setting and getting complex properties such as privacy,

    // TODO: Validation of zip code, dealer sincom, phone number, email, IP address
}
