<?php

namespace FCAPoland\LeadsAPIHelper\Request;

use FCAPoland\LeadsAPIHelper\Exception;
use FCAPoland\LeadsAPIHelper\Lead;
use FCAPoland\LeadsAPIHelper\Request;

class Create extends Request
{
    /**
     * @var Lead
     */
    private $lead;

    protected $method = self::METHOD_PUT;

    protected function createBody()
    {
        return json_encode($this->lead->getProperties());
    }

    public function setLead(Lead $lead)
    {
        $this->lead = $lead;
    }

    public function execute()
    {
        if (!($this->lead instanceof Lead)) {
            throw new Exception(
                'Unable to execute lead create request with no lead data provided. Please attach a lead to the request.'
            );
        }

        $response = parent::execute();
        // First, check for cURL errors. The 'error' field will be filled with such errors after request execution.
        if ($this->error) {
            // If there is an error - do not try to guess any other (FCA API as an application) errors, (i.e. skip it).
            return $response;
        }

        $response_body = $this->getResponseBody();

        if ($response and 201 === $this->getResponseCode() and is_numeric($response_body)) {
            // Remember ID of newly created lead
            $this->lead->setId(intval($response_body));
        } else {
            if ($response_decoded = json_decode($response_body, true) and $response_decoded !== null) {
                if (is_array($response_decoded) and array_key_exists('message', $response_decoded)) {
                    $this->error = $response_decoded['message'];
                } else {
                    $this->error = json_encode($response_body);
                }
            } else {
                $this->error = 'Unrecognized error';
            }
        }

        return $response;
    }
}
