<?php

namespace FCAPoland\LeadsAPIHelper\Request;

use FCAPoland\LeadsAPIHelper\APIException;
use FCAPoland\LeadsAPIHelper\BadRequestException;
use FCAPoland\LeadsAPIHelper\Exception;
use FCAPoland\LeadsAPIHelper\Lead;
use FCAPoland\LeadsAPIHelper\Request;

class Create extends Request
{
    /**
     * @var Lead
     */
    private $lead;

    protected $method = self::METHOD_PUT;

    protected function createBody()
    {
        return json_encode($this->lead->getProperties());
    }

    public function setLead(Lead $lead)
    {
        $this->lead = $lead;
    }

    /**
     * @throws Exception
     */
    public function execute()
    {
        if (!($this->lead instanceof Lead)) {
            throw new Exception(
                'Unable to execute lead create request with no lead data provided. Please attach a lead to the request.'
            );
        }

        try {
            parent::execute();
        } catch (APIException $api_exception) {
            throw new Exception($api_exception->getMessage(), $api_exception->getCode());
        }

        $response_body = $this->getResponseBody();

        if (201 === $this->getResponseCode() and is_numeric($response_body)) {
            // Remember ID of newly created lead
            $this->lead->setId(intval($response_body));
        } else {
            throw new Exception('Unrecognized error');
        }
    }
}
