Leads API Helper
=================

Helping people work with FCA Leads API webservice (https://api.fcapoland.pl/leads).

Simple usage by example:

1. Include the library in your project:

   `$ composer require fca-poland/leads-api-helper`

2. Use it:
    ```php
    <?php
    require_once "vendor/autoload.php";

    $lead = new \FCAPoland\LeadsAPIHelper\Lead();
    // Attach logger if necessary
    $lead->setLogger(new \Psr\Log\NullLogger());
    $lead->setProperties([
        'type' => \FCAPoland\LeadsAPIHelper\Lead::TYPE_GETAQUOTE,
        'first_name' => 'Foo',
        'last_name' => 'Bar',
        'device' => \FCAPoland\LeadsAPIHelper\Lead::DEVICE_MOBILE,
        'privacy' => [
            \FCAPoland\LeadsAPIHelper\Lead::PRIVACY_TYPE_MARKETING => \FCAPoland\LeadsAPIHelper\Lead::PRIVACY_ACCEPTED,
            \FCAPoland\LeadsAPIHelper\Lead::PRIVACY_TYPE_PROFILING => \FCAPoland\LeadsAPIHelper\Lead::PRIVACY_REFUSED,
            \FCAPoland\LeadsAPIHelper\Lead::PRIVACY_TYPE_3RD_PARTY_MARKETING => \FCAPoland\LeadsAPIHelper\Lead::PRIVACY_ACCEPTED,
        ],
        // ...
    ]);

    $lead->setBrandId(\FCAPoland\LeadsAPIHelper\Lead::BRAND_JEEP);
    $lead->setOrigin('My landing page');
    // other `$lead->set...` comes here

    // setup API request:
    $api_url = 'https://api.fcapoland.pl';
    $api_user = 'johndoe';
    $api_pass = 'crackme';

    $api_request = new \FCAPoland\LeadsAPIHelper\Request\Create($api_url, $api_user, $api_pass);
    // or:
    $api_request = new \FCAPoland\LeadsAPIHelper\Request\Create();
    $api_request->setURL($api_url);
    $api_request->setUsername($api_user);
    $api_request->setPassword($api_pass);

    // Attach lead to the request
    $api_request->setLead($lead);

    try {
        $api_request->execute();
    } catch (\FCAPoland\LeadsAPIHelper\Exception $exception) {
        // Handle errors
        die($exception->getMessage());
    }
    $lead_id = $lead->getId();
    ```

Development
-----------

> For Docker development environment see next section.

1. Instal development dependencies:

    `$ composer install --dev`

2. Checkout to development branch:

    `$ git checkout -b dev/feature-1`

3. Do the development (remember about tests!)
4. Sniff the code and detect mess:

    ```
    $ ./sniff-the-code.sh
    $ ./detect-mess.sh
    ```
5. Test:

    `$ ./test.sh`

   Leads API requires authorization. To pass authorization to the tests use following global constants (for example
   within your custom tests boostrap file, that sets constants and then calls regular, project's `tests/bootstrap.php`
   file saving other bootstraped settings):
    - `LEADS_API_USERNAME`
    - `LEADS_API_PASSWORD`

   Example:
   ```php
   <?php // contents of `my_bootstrap.php`
   define('LEADS_API_USERNAME', 'johndoe');
   define('LEADS_API_PASSWORD', 'breakmedown');
   require_once __DIR__ . '/tests/bootstrap.php';
   ```

   Also, one can override default API URL (which is `https://api.fcapoland.pl/leads`) by defining one's own using
   `LEADS_API_URL` constant the same way like for username and password:

   ```php
   <?php // contents of `my_bootstrap.php`
   define('LEADS_API_URL', 'http://localhost:8080');
   require_once __DIR__ . '/tests/bootstrap.php';
   ```

   And then:

       $ php ./vendor/bin/phpunit --bootstrap my_bootstrap.php

   or, if `test.sh` is availabe:

        $ ./test.sh --bootstrap my_bootstrap.php
        
   Note that there are currently two testsuites: `Unit` and `Functional`. The latter requires actual FCA API instance
   to be running and available. To use only single testsuite use `--testsuite` param like follows:

        $ ./test.sh --bootstrap my_bootstrap.php --testsuite Unit
   
6. Merge or create merge request.
7. Be happy PHP developer!

Docker
------

Docker utilities are available through `docker-compose`:

    $ docker-compose build

Then install Composer dependencies using:

    $ ./php56.sh composer.phar install

When testing using Docker environment use `--docker` parameter added to the `test.sh` script, for example:

    $ ./test.sh --docker --bootstrap my_bootstrap.php
