<?php
declare(strict_types=1);

namespace FCAPoland\LeadsAPIHelper\Request;

use FCAPoland\LeadsAPIHelper\Exception\APIException;
use FCAPoland\LeadsAPIHelper\Exception;
use FCAPoland\LeadsAPIHelper\Lead;
use FCAPoland\LeadsAPIHelper\Request;

class Create extends Request
{
    const QUERY_PARAM_SKIP_CALLCENTER = 'skip-callcenter-verification';

    /**
     * @var Lead
     */
    private $lead;

    protected $method = self::METHOD_PUT;

    protected function createBody()
    {
        return json_encode($this->lead->getProperties());
    }

    public function setLead(Lead $lead)
    {
        $this->lead = $lead;
    }

    /**
     * @throws Exception
     */
    public function execute()
    {
        if (!($this->lead instanceof Lead)) {
            throw new Exception(
                'Unable to execute lead create request with no lead data provided. Please attach a lead to the request.'
            );
        }

        if ($this->lead->getSkipCallCenterVerification()) {
            $this->setQueryParam(self::QUERY_PARAM_SKIP_CALLCENTER, true);
        }

        try {
            parent::execute();
        } catch (APIException $api_exception) {
            throw new Exception($api_exception->getMessage(), $api_exception->getCode());
        }

        $response_body = $this->getResponseBody();

        if (201 === $this->getResponseCode() and is_numeric($response_body)) {
            // Remember ID of newly created lead
            $this->lead->setId(intval($response_body));
        } else {
            throw new Exception('Unrecognized error');
        }
    }
}
