<?php
declare(strict_types=1);

/**
 * Created by PhpStorm.
 * User: Damian Banaszkiewicz <dbanaszkiewicz@unicorn.net.pl>
 * Date: 19.06.18
 * Time: 11:53
 */

namespace FCAPoland\LeadsAPIHelper;

use FCAPoland\LeadsAPIHelper\MasterkeyDebugger\HtmlGenerator;

/**
 * Class MasterkeyDebugger
 * @package FCAPoland\LeadsAPIHelper
 */
class MasterkeyDebugger
{
    private $isActive = false;
    /**
     * @var MasterkeyFinder
     */
    private $mkFinder = null;

    /**
     * @var array
     */
    private $types = [];

    /**
     * MasterkeyDebugger constructor.
     * @param MasterkeyFinder $masterkeyFinder
     */
    public function __construct(MasterkeyFinder $masterkeyFinder)
    {
        $this->mkFinder = $masterkeyFinder;
    }

    public function run()
    {
        $this->isActive = true;
    }

    /**
     * @param string $mkType
     */
    public function addMkType($mkType)
    {
        if (!in_array($mkType, $this->types)) {
            $this->types[] = $mkType;
        }
    }

    /**
     * Return content of CSS file
     * @return string
     */
    public function getCssFileContent()
    {
        if ($this->isActive) {
            if (file_exists(dirname(__DIR__) . "/assets/MasterkeyDebugger/Style.css")) {
                $data = file_get_contents(dirname(__DIR__) . "/assets/MasterkeyDebugger/Style.css");

                if ($data !== false) {
                    return $data;
                }
            }
        }
        return '';
    }

    /**
     * @return string
     * @throws Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     */
    public function getHTML()
    {
        $html = '';

        if ($this->isActive) {
            $debugData = $this->getDebugInfo();
            $html = (new HtmlGenerator($debugData))->getHtml();
        }

        return $html;
    }


    /**
     * @return array
     * @throws Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     */
    private function getDebugInfo()
    {
        $debugInfo = [
            'parameters' => [
                'brand_id' => $this->mkFinder->getBrand(),
                'type' => $this->mkFinder->getType(),
                'campaign_id' => $this->mkFinder->getCid(),
                'offer_id' => $this->mkFinder->getOid(),
                'source' => $this->mkFinder->getSource(),
                'default_source' => $this->mkFinder->getDefaultSource(),
                'app_campaign_id' => $this->mkFinder->getAppCid(),
                'app_offer_id' => $this->mkFinder->getAppOid(),
                'app_source' => $this->mkFinder->getAppSource(),
            ],
            'results' => [],
        ];

        foreach ($this->types as $type) {
            $this->mkFinder->find($type);
            $masterkey = $this->mkFinder->getMasterkey();
            $debugInfo['results'][$type] = [
                'id' => $masterkey->getId(),
                'brand' => $masterkey->getBrand(),
                'type' => $masterkey->getType(),
                'source' => $masterkey->getSource(),
                'cid' => $masterkey->getCid(),
                'oid' => $masterkey->getOid(),
            ];
        }
        return $debugInfo;
    }
}
