<?php
declare(strict_types=1);

/**
 * Created by PhpStorm.
 * User: Damian Banaszkiewicz <dbanaszkiewicz@unicorn.net.pl>
 * Date: 21.06.18
 * Time: 09:55
 */

namespace FCAPoland\LeadsAPIHelper\MasterkeyDebugger;

/**
 * Class HtmlGenerator
 * @package FCAPoland\LeadsAPIHelper\MasterkeyDebugger
 */
class HtmlGenerator
{
    /**
     * @var string|null
     */
    private $html = null;

    /**
     * @var null|array
     */
    private $data = null;

    /**
     * HtmlGenerator constructor.
     * @param array $debugData
     */
    public function __construct($debugData)
    {
        $this->data = $debugData;

        if (file_exists(dirname(dirname(__DIR__)) . "/assets/MasterkeyDebugger/Template.html")) {
            $data = file_get_contents(dirname(dirname(__DIR__)) . "/assets/MasterkeyDebugger/Template.html");

            if ($data !== false) {
                $this->html = $data;
            }
        }

        $this->render();
    }

    private function render()
    {
        $this->insertParameters();
        $this->insertResults();
    }

    /**
     * @return null|string
     */
    public function getHtml()
    {
        return $this->html;
    }

    private function insertParameters()
    {
        $this->html = str_replace('{param_brand_id}', $this->data['parameters']['brand_id'], $this->html);
        $this->html = str_replace('{param_cid}', $this->data['parameters']['campaign_id'], $this->html);
        $this->html = str_replace('{param_oid}', $this->data['parameters']['offer_id'], $this->html);
        $this->html = str_replace('{param_source}', $this->data['parameters']['source'], $this->html);
        $this->html = str_replace('{param_app_cid}', $this->data['parameters']['app_campaign_id'], $this->html);
        $this->html = str_replace('{param_app_oid}', $this->data['parameters']['app_offer_id'], $this->html);
        $this->html = str_replace('{param_app_source}', $this->data['parameters']['app_source'], $this->html);
    }

    private function insertResults()
    {
        $start = stripos($this->html, '{resultRow}');
        $end = stripos($this->html, '{/resultRow}');

        if ($start !== false and $end !== false) {
            $row = substr($this->html, $start + 11, $end - $start - 11);

            $resultsHtml = "";

            foreach ($this->data['results'] as $mk) {
                $h = $row;

                $h = str_replace('{id}', $mk['id'], $h);
                $h = str_replace('{type}', $mk['type'], $h);
                $h = str_replace('{brand_id}', $mk['brand'], $h);
                $h = str_replace('{cid}', $mk['cid'], $h);
                $h = str_replace('{oid}', $mk['oid'], $h);
                $h = str_replace('{source}', $mk['source'], $h);

                $resultsHtml .= $h;
            }

            $this->html = substr($this->html, 0, $start)
                . $resultsHtml . substr($this->html, $end + 12);
        }
    }
}
