<?php
declare(strict_types=1);

namespace FCAPoland\LeadsAPIHelper;

use FCAPoland\LeadsAPIHelper\Exception\APIException;
use FCAPoland\LeadsAPIHelper\Exception\InvalidArgumentException;
use FCAPoland\LeadsAPIHelper\Exception\LeadsAPIHelperException;

/**
 * Wrapper for `Request\CheckCcVerification` to make checking easier and typed (`CheckCcVerification\Result`)
 */
class CheckCcVerification
{
    /**
     * @var Request\CheckCcVerification
     */
    private $request;

    public function __construct(?string $url = null, ?string $api_username = null, ?string $api_password = null)
    {
        $this->request = new Request\CheckCcVerification($url, $api_username, $api_password);
    }

    public function withId($id): CheckCcVerification\Result
    {
        $request = clone $this->request;
        try {
            $request->setID($id);
            $request->execute();
        } catch (InvalidArgumentException $exception) {
            return new CheckCcVerification\Result(CheckCcVerification\Result::INVALID_ID);
        } catch (LeadsAPIHelperException $exception) {
            if ($exception instanceof APIException && $exception->getCode() === 404) {
                return new CheckCcVerification\Result(CheckCcVerification\Result::NOT_FOUND);
            }
            return new CheckCcVerification\Result(CheckCcVerification\Result::SERVER_ERROR);
        }

        if ($request->getResponseBody() === 'true') {
            return new CheckCcVerification\Result(CheckCcVerification\Result::TRUE);
        }

        if ($request->getResponseBody() === 'false') {
            return new CheckCcVerification\Result(CheckCcVerification\Result::FALSE);
        }

        return new CheckCcVerification\Result(CheckCcVerification\Result::UNKNOWN);
    }
}
