<?php
declare(strict_types=1);

namespace FCAPoland\LeadsAPIHelper\CheckCcVerification;

use FCAPoland\LeadsAPIHelper\Exception\InvalidArgumentException;

class Result
{
    public const TRUE = true;
    public const FALSE = false;
    public const INVALID_ID = 'INVALID ID';
    public const NOT_FOUND = 'NOT FOUND';
    public const SERVER_ERROR = 'SERVER ERROR';
    public const UNKNOWN = 'UNKNOWN';

    /**
     * @var true|false|string
     */
    private $value;

    public function __construct($value)
    {
        $valids = [self::TRUE, self::FALSE, self::NOT_FOUND, self::INVALID_ID, self::SERVER_ERROR, self::UNKNOWN];
        if (!in_array($value, $valids, true)) {
            throw new InvalidArgumentException(sprintf(
                'Invalid result value "%s" (%s), valid are: %s',
                $value,
                gettype($value),
                implode(', ', $valids)
            ));
        }

        $this->value = $value;
    }

    /**
     * @return true|false|string
     */
    public function getValue()
    {
        return $this->value;
    }

    public function isTrue(): bool
    {
        return $this->value === self::TRUE;
    }

    public function isFalse(): bool
    {
        return $this->value === self::FALSE;
    }

    public function isInvalidId(): bool
    {
        return $this->value === self::INVALID_ID;
    }

    public function isNotFound(): bool
    {
        return $this->value === self::NOT_FOUND;
    }

    public function isServerError(): bool
    {
        return $this->value === self::SERVER_ERROR;
    }

    public function isUnknown(): bool
    {
        return $this->value === self::UNKNOWN;
    }
}
