<?php
declare(strict_types=1);

namespace FCAPoland\LeadsAPIHelper\CheckCcVerificationStatus;

use FCAPoland\LeadsAPIHelper\Exception\InvalidArgumentException;

class Result
{
    public const INVALID_ID = 'INVALID_ID';
    public const UNKNOWN = 'UNKNOWN';
    public const SERVER_ERROR = 'SERVER_ERROR';
    public const NOT_FOUND = 'NOT_FOUND';
    public const SKIP_CALL_CENTER_VERIFICATION = 'SKIP_CALL_CENTER_VERIFICATION';
    public const NOT_RETURN_FLOW2 = 'NOT_RETURN_FLOW2';
    public const OPEN = 'OPEN';
    public const REJECTED = 'REJECTED';
    public const ACCEPTED = 'ACCEPTED';

    /**
     * @var true|false|string
     */
    private $value;

    public function __construct($value)
    {
        $valid_statuses = [
            self::INVALID_ID,
            self::UNKNOWN,
            self::SERVER_ERROR,
            self::NOT_FOUND,
            self::SKIP_CALL_CENTER_VERIFICATION,
            self::NOT_RETURN_FLOW2,
            self::OPEN,
            self::REJECTED,
            self::ACCEPTED,
        ];
        if (!in_array($value, $valid_statuses, true)) {
            throw new InvalidArgumentException(sprintf(
                'Invalid result value "%s" (%s), valid are: %s',
                $value,
                gettype($value),
                implode(', ', $valid_statuses)
            ));
        }

        $this->value = $value;
    }

    /**
     * @return true|false|string
     */
    public function getValue()
    {
        return $this->value;
    }

    public function isInvalidId(): bool
    {
        return $this->value === self::INVALID_ID;
    }

    public function isUnknown(): bool
    {
        return $this->value === self::UNKNOWN;
    }

    public function isServerError(): bool
    {
        return $this->value === self::SERVER_ERROR;
    }

    public function isNotFound(): bool
    {
        return $this->value === self::NOT_FOUND;
    }

    public function isSkipCC(): bool
    {
        return $this->value === self::SKIP_CALL_CENTER_VERIFICATION;
    }

    public function isNoReturnFlow2(): bool
    {
        return $this->value === self::NOT_RETURN_FLOW2;
    }

    public function isOpen(): bool
    {
        return $this->value === self::OPEN;
    }

    public function isRejected(): bool
    {
        return $this->value === self::REJECTED;
    }

    public function isAccepted(): bool
    {
        return $this->value === self::ACCEPTED;
    }
}
