<?php
declare(strict_types=1);

namespace FCAPoland\LeadsAPIHelper;

/**
 * Class Masterkey
 * @package FCAPoland\LeadsAPIHelper
 */
class Masterkey
{
    /** @var int */
    private $id;

    /** @var string */
    private $brand;

    /** @var string */
    private $type;

    /** @var int */
    private $cid;

    /** @var int|null */
    private $oid;

    /** @var string */
    private $source;

    /**
     * Masterkey constructor.
     * @param int $id
     * @param string $brand
     * @param string $type
     * @param int $cid
     * @param int|null $oid
     * @param string $source
     */
    public function __construct(int $id, string $brand, string $type, int $cid, ?int $oid, string $source)
    {
        $this->id = $id;
        $this->brand = $brand;
        $this->type = $type;
        $this->cid = $cid;
        $this->oid = $oid;
        $this->source = $source;
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getBrand(): string
    {
        return $this->brand;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return int
     */
    public function getCid(): int
    {
        return $this->cid;
    }

    /**
     * @return int|null
     */
    public function getOid(): ?int
    {
        return $this->oid;
    }

    /**
     * @return string
     */
    public function getSource(): string
    {
        return $this->source;
    }
}
