<?php

namespace Tests\Functional;

use FCAPoland\LeadsAPIHelper;
use PHPUnit\Framework\TestCase;

/**
 * These tests require fully functional HTTP server serving API data from any source:
 *  - development
 *  - tests
 *  - production
 *
 * Please check `LEADS_API_URL` constant than can be set in PHPUnit's `bootstrap.php` file.
 *
 * @package Tests\Functional
 */
class CheckCcVerificationTest extends TestCase
{
    /**
     * @var string
     */
    private $url;

    /**
     * @var string
     */
    private $username;

    /**
     * @var string
     */
    private $password;

    private $lead_to_exits_check;

    protected function setUp(): void
    {
        parent::setUp();

        if (defined('LEADS_API_URL')) {
            $this->url = LEADS_API_URL;
        }

        if (defined('LEADS_API_USERNAME')) {
            $this->username = LEADS_API_USERNAME;
        }

        if (defined('LEADS_API_PASSWORD')) {
            $this->password = LEADS_API_PASSWORD;
        }

        if (defined('LEAD_HUB_ID_TO_CHECK_EXITS')) {
            $this->lead_to_exits_check = LEAD_HUB_ID_TO_CHECK_EXITS;
        }
    }

    public function testCheckExisting()
    {
        if (!empty($this->lead_to_exits_check)) {
            $api_request = new LeadsAPIHelper\Request\CheckCcVerification($this->url, $this->username, $this->password);
            $api_request->setID($this->lead_to_exits_check);
            $api_request->execute();

            $this->assertEquals('true', $api_request->getResponseBody());
            $this->assertEquals(200, $api_request->getResponseCode());
        } else {
            $this->markTestSkipped('LEAD_HUB_ID_TO_CHECK_EXITS is not set, for check LEAD CC verification');
        }
    }

    public function testCheckInexisting()
    {
        $api_request = new LeadsAPIHelper\Request\CheckCcVerification($this->url, $this->username, $this->password);
        $api_request->setID('PL000000000123456789');
        $this->expectException(LeadsAPIHelper\Exception\APIException::class);
        $api_request->execute();
    }

    public function testCheckInvalid()
    {
        $api_request = new LeadsAPIHelper\Request\CheckCcVerification($this->url, $this->username, $this->password);
        $this->expectException(LeadsAPIHelper\Exception\InvalidArgumentException::class);
        $api_request->setID('FOOBAR');
        $api_request->execute();
    }

    public function testWrapperCheck()
    {
        $obj = new \FCAPoland\LeadsAPIHelper\CheckCcVerification($this->url, $this->username, $this->password);
        $result = $obj->withId('PL1688940');
        $this->assertEquals(LeadsAPIHelper\CheckCcVerification\Result::TRUE, $result->getValue());
        $result = $obj->withId('PL000000000123456789');
        $this->assertEquals(LeadsAPIHelper\CheckCcVerification\Result::NOT_FOUND, $result->getValue());
        $result = $obj->withId('FOOBAR');
        $this->assertEquals(LeadsAPIHelper\CheckCcVerification\Result::INVALID_ID, $result->getValue());
    }
}
