<?php
declare(strict_types=1);

namespace FCAPoland\LeadsAPIHelper;

use FCAPoland\LeadsAPIHelper\Exception\APIException;
use FCAPoland\LeadsAPIHelper\Exception\InvalidArgumentException;
use FCAPoland\LeadsAPIHelper\Exception\LeadsAPIHelperException;

/**
 * Wrapper for `Request\CheckCcVerificationStatus.` to make checking easier and typed (`CheckCcVerificationStatus\Result`)
 */
class CheckCcVerificationStatus
{
    /**
     * @var Request\CheckCcVerificationStatus
     */
    private $request;

    public function __construct(?string $url = null, ?string $api_username = null, ?string $api_password = null)
    {
        $this->request = new Request\CheckCcVerificationStatus($url, $api_username, $api_password);
    }

    public function withId($id): CheckCcVerificationStatus\Result
    {
        $request = clone $this->request;
        try {
            $request->setID($id);
            $request->execute();
        } catch (InvalidArgumentException $exception) {
            return new CheckCcVerificationStatus\Result(CheckCcVerificationStatus\Result::INVALID_ID);
        } catch (LeadsAPIHelperException $exception) {
            if ($exception instanceof APIException && $exception->getCode() === 404) {
                return new CheckCcVerificationStatus\Result(CheckCcVerificationStatus\Result::NOT_FOUND);
            }
            return new CheckCcVerificationStatus\Result(CheckCcVerificationStatus\Result::SERVER_ERROR);
        }

        try {
            return new CheckCcVerificationStatus\Result(trim($request->getResponseBody(), '"'));
        } catch (LeadsAPIHelperException $exception) {
            return new CheckCcVerificationStatus\Result(CheckCcVerificationStatus\Result::UNKNOWN);
        }
    }
}
