<?php
declare(strict_types=1);

namespace FCAPoland\LeadsAPIHelper\Request;

class CheckCcVerificationStatus extends CheckCcVerification
{
    public const ENDPOINT = '/leads/cc-verification-status/<id>';

    public function __construct(?string $url = null, ?string $api_username = null, ?string $api_password = null)
    {
        parent::__construct($url, $api_username, $api_password);

        // Replace endpoint path
        $this->setURL(str_replace(parse_url($this->url, PHP_URL_PATH), self::ENDPOINT, $this->url));
    }
}
